﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Forms;
using System.IO;
using System.Text;

namespace KeyConfig
{
	static class Program
	{
		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		[STAThread]
		static void Main()
		{
#if DEBUG
			logSwitch = true;
#endif
			OpenLog(frmMain.Files.Debug);

			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
			Application.Run(new frmMain());
		}

		static bool logSwitch = Environment.CommandLine.Contains("-l");
		static StreamWriter sw;

		internal static void OpenLog(string path)
		{
			if (logSwitch)
			{
				sw = new StreamWriter(path, true, Encoding.UTF8);
			}
		}

		internal static void WriteLog(string log)
		{
			if (logSwitch)
			{
				sw.WriteLine(log);
				sw.Flush();
			}
		}

		internal static void CloseLog()
		{
			if ((logSwitch) && (sw != null))
			{
				sw.WriteLine();
				sw.Flush();
				sw.Close();
				sw = null;
			}
		}
	}
}
